<?php
function install_gmaps() {

    require_once('ModuleInstall/ModuleInstaller.php');
    $ModuleInstaller = new ModuleInstaller();
    $ModuleInstaller->install_custom_fields(getCustomFields());

    addMapHooks();

}

function addMapHooks(){

    $hooks = getMapHooks();
    foreach($hooks as $hook ) {
        check_logic_hook_file($hook['module'], $hook['hook'], array($hook['order'], $hook['description'],  $hook['file'], $hook['class'], $hook['function']));
    }
}

function getMapHooks(){
    $logic_hooks = array(

        // Prospects
        array(
            'module'         => 'Prospects',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Prospects/ProspectsJjwg_MapsLogicHook.php',
            'class'          => 'ProspectsJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Prospects',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Prospects/ProspectsJjwg_MapsLogicHook.php',
            'class'          => 'ProspectsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),

        // Leads
        array(
            'module'         => 'Leads',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Leads/LeadsJjwg_MapsLogicHook.php',
            'class'          => 'LeadsJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Leads',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Leads/LeadsJjwg_MapsLogicHook.php',
            'class'          => 'LeadsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),

        // Contacts
        array(
            'module'         => 'Contacts',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Contacts/ContactsJjwg_MapsLogicHook.php',
            'class'          => 'ContactsJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Contacts',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Contacts/ContactsJjwg_MapsLogicHook.php',
            'class'          => 'ContactsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),

        // Meetings
        array(
            'module'         => 'Meetings',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateMeetingGeocodeInfo',
            'file'           => 'custom/modules/Meetings/MeetingsJjwg_MapsLogicHook.php',
            'class'          => 'MeetingsJjwg_MapsLogicHook',
            'function'       => 'updateMeetingGeocodeInfo',
        ),

        // Opportunities (5 hooks)
        array(
            'module'         => 'Opportunities',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Opportunities/OpportunitiesJjwg_MapsLogicHook.php',
            'class'          => 'OpportunitiesJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Opportunities',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Opportunities/OpportunitiesJjwg_MapsLogicHook.php',
            'class'          => 'OpportunitiesJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),
        array(
            'module'         => 'Opportunities',
            'hook'           => 'after_save',
            'order'          => 78,
            'description'    => 'updateRelatedProjectGeocodeInfo',
            'file'           => 'custom/modules/Opportunities/OpportunitiesJjwg_MapsLogicHook.php',
            'class'          => 'OpportunitiesJjwg_MapsLogicHook',
            'function'       => 'updateRelatedProjectGeocodeInfo',
        ),
        array(
            'module'         => 'Opportunities',
            'hook'           => 'after_relationship_add',
            'order'          => 77,
            'description'    => 'addRelationship',
            'file'           => 'custom/modules/Opportunities/OpportunitiesJjwg_MapsLogicHook.php',
            'class'          => 'OpportunitiesJjwg_MapsLogicHook',
            'function'       => 'addRelationship',
        ),
        array(
            'module'         => 'Opportunities',
            'hook'           => 'after_relationship_delete',
            'order'          => 77,
            'description'    => 'deleteRelationship',
            'file'           => 'custom/modules/Opportunities/OpportunitiesJjwg_MapsLogicHook.php',
            'class'          => 'OpportunitiesJjwg_MapsLogicHook',
            'function'       => 'deleteRelationship',
        ),

        // Cases (4 Hooks)
        array(
            'module'         => 'Cases',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Cases/CasesJjwg_MapsLogicHook.php',
            'class'          => 'CasesJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Cases',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Cases/CasesJjwg_MapsLogicHook.php',
            'class'          => 'CasesJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),
        array(
            'module'         => 'Cases',
            'hook'           => 'after_relationship_add',
            'order'          => 77,
            'description'    => 'addRelationship',
            'file'           => 'custom/modules/Cases/CasesJjwg_MapsLogicHook.php',
            'class'          => 'CasesJjwg_MapsLogicHook',
            'function'       => 'addRelationship',
        ),
        array(
            'module'         => 'Cases',
            'hook'           => 'after_relationship_delete',
            'order'          => 77,
            'description'    => 'deleteRelationship',
            'file'           => 'custom/modules/Cases/CasesJjwg_MapsLogicHook.php',
            'class'          => 'CasesJjwg_MapsLogicHook',
            'function'       => 'deleteRelationship',
        ),

        // Project (4 Hooks)
        array(
            'module'         => 'Project',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Project/ProjectJjwg_MapsLogicHook.php',
            'class'          => 'ProjectJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Project',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Project/ProjectJjwg_MapsLogicHook.php',
            'class'          => 'ProjectJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),
        array(
            'module'         => 'Project',
            'hook'           => 'after_relationship_add',
            'order'          => 77,
            'description'    => 'addRelationship',
            'file'           => 'custom/modules/Project/ProjectJjwg_MapsLogicHook.php',
            'class'          => 'ProjectJjwg_MapsLogicHook',
            'function'       => 'addRelationship',
        ),
        array(
            'module'         => 'Project',
            'hook'           => 'after_relationship_delete',
            'order'          => 77,
            'description'    => 'deleteRelationship',
            'file'           => 'custom/modules/Project/ProjectJjwg_MapsLogicHook.php',
            'class'          => 'ProjectJjwg_MapsLogicHook',
            'function'       => 'deleteRelationship',
        ),

        // Accounts (7 hooks)
        array(
            'module'         => 'Accounts',
            'hook'           => 'before_save',
            'order'          => 77,
            'description'    => 'updateGeocodeInfo',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'updateGeocodeInfo',
        ),
        array(
            'module'         => 'Accounts',
            'hook'           => 'after_save',
            'order'          => 77,
            'description'    => 'updateRelatedMeetingsGeocodeInfo',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedMeetingsGeocodeInfo',
        ),
        array(
            'module'         => 'Accounts',
            'hook'           => 'after_save',
            'order'          => 78,
            'description'    => 'updateRelatedProjectGeocodeInfo',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedProjectGeocodeInfo',
        ),
        array(
            'module'         => 'Accounts',
            'hook'           => 'after_save',
            'order'          => 79,
            'description'    => 'updateRelatedOpportunitiesGeocodeInfo',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedOpportunitiesGeocodeInfo',
        ),
        array(
            'module'         => 'Accounts',
            'hook'           => 'after_save',
            'order'          => 80,
            'description'    => 'updateRelatedCasesGeocodeInfo',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'updateRelatedCasesGeocodeInfo',
        ),
        array(
            'module'         => 'Accounts',
            'hook'           => 'after_relationship_add',
            'order'          => 77,
            'description'    => 'addRelationship',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'addRelationship',
        ),
        array(
            'module'         => 'Accounts',
            'hook'           => 'after_relationship_delete',
            'order'          => 77,
            'description'    => 'deleteRelationship',
            'file'           => 'custom/modules/Accounts/AccountsJjwg_MapsLogicHook.php',
            'class'          => 'AccountsJjwg_MapsLogicHook',
            'function'       => 'deleteRelationship',
        ),

    );
    return $logic_hooks;
}

function getCustomFields(){
    $custom_fields =
  array (
      'Accountsjjwg_maps_lng_c' =>
      array (
          'id' => 'Accountsjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Accounts',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Accountsjjwg_maps_lat_c' =>
      array (
          'id' => 'Accountsjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Accounts',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Accountsjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Accountsjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Accounts',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Accountsjjwg_maps_address_c' =>
      array (
          'id' => 'Accountsjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Accounts',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Casesjjwg_maps_lng_c' =>
      array (
          'id' => 'Casesjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Cases',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Casesjjwg_maps_lat_c' =>
      array (
          'id' => 'Casesjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Cases',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Casesjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Casesjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Cases',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Casesjjwg_maps_address_c' =>
      array (
          'id' => 'Casesjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Cases',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Contactsjjwg_maps_lng_c' =>
      array (
          'id' => 'Contactsjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Contacts',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Contactsjjwg_maps_lat_c' =>
      array (
          'id' => 'Contactsjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Contacts',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Contactsjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Contactsjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Contacts',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Contactsjjwg_maps_address_c' =>
      array (
          'id' => 'Contactsjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Contacts',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Leadsjjwg_maps_lng_c' =>
      array (
          'id' => 'Leadsjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Leads',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Leadsjjwg_maps_lat_c' =>
      array (
          'id' => 'Leadsjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Leads',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Leadsjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Leadsjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Leads',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Leadsjjwg_maps_address_c' =>
      array (
          'id' => 'Leadsjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Leads',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Meetingsjjwg_maps_lng_c' =>
      array (
          'id' => 'Meetingsjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Meetings',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Meetingsjjwg_maps_lat_c' =>
      array (
          'id' => 'Meetingsjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Meetings',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Meetingsjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Meetingsjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Meetings',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default_value' => NULL,
          'date_modified' => '2012-08-17 22:06:01',
          'deleted' => '0',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Meetingsjjwg_maps_address_c' =>
      array (
          'id' => 'Meetingsjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Meetings',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Opportunitiesjjwg_maps_lng_c' =>
      array (
          'id' => 'Opportunitiesjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Opportunities',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Opportunitiesjjwg_maps_lat_c' =>
      array (
          'id' => 'Opportunitiesjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Opportunities',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Opportunitiesjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Opportunitiesjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Opportunities',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Opportunitiesjjwg_maps_address_c' =>
      array (
          'id' => 'Opportunitiesjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Opportunities',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Projectjjwg_maps_lng_c' =>
      array (
          'id' => 'Projectjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Project',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Projectjjwg_maps_lat_c' =>
      array (
          'id' => 'Projectjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Project',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Projectjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Projectjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Project',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Projectjjwg_maps_address_c' =>
      array (
          'id' => 'Projectjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Project',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2010-09-18 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Prospectsjjwg_maps_lng_c' =>
      array (
          'id' => 'Prospectsjjwg_maps_lng_c',
          'name' => 'jjwg_maps_lng_c',
          'label' => 'LBL_JJWG_MAPS_LNG',
          'comments' => NULL,
          'help' => 'Longitude',
          'module' => 'Prospects',
          'type' => 'float',
          'max_size' => '11',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Prospectsjjwg_maps_lat_c' =>
      array (
          'id' => 'Prospectsjjwg_maps_lat_c',
          'name' => 'jjwg_maps_lat_c',
          'label' => 'LBL_JJWG_MAPS_LAT',
          'comments' => NULL,
          'help' => 'Latitude',
          'module' => 'Prospects',
          'type' => 'float',
          'max_size' => '10',
          'require_option' => '0',
          'default' => '0.00000000',
          'default_value' => '0.00000000',
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'precision' => '8',
          'ext1' => '8',
      ),
      'Prospectsjjwg_maps_geocode_status_c' =>
      array (
          'id' => 'Prospectsjjwg_maps_geocode_status_c',
          'name' => 'jjwg_maps_geocode_status_c',
          'label' => 'LBL_JJWG_MAPS_GEOCODE_STATUS',
          'comments' => 'Geocode Status',
          'help' => 'Geocode Status',
          'module' => 'Prospects',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
      'Prospectsjjwg_maps_address_c' =>
      array (
          'id' => 'Prospectsjjwg_maps_address_c',
          'name' => 'jjwg_maps_address_c',
          'label' => 'LBL_JJWG_MAPS_ADDRESS',
          'comments' => 'Address',
          'help' => 'Address',
          'module' => 'Prospects',
          'type' => 'varchar',
          'max_size' => '255',
          'require_option' => '0',
          'default' => NULL,
          'default_value' => NULL,
          'date_modified' => '2012-08-17 22:06:01',
          'audited' => '0',
          'mass_update' => '0',
          'duplicate_merge' => '0',
          'reportable' => '1',
          'importable' => 'true',
          'ext1' => NULL,
      ),
  );

	return $custom_fields;
}
